/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import noppes.npcs.NBTTags;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.data.role.IJobSpawner;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.data.SpawnNPCData;
import org.apache.commons.lang3.RandomStringUtils;

public class JobSpawner
extends JobInterface
implements IJobSpawner {
    private String id = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
    private SpawnNPCData[][] dataEntitys = new SpawnNPCData[2][];
    public final int[][] offset;
    private final int[] spawnType;
    private final int[] number;
    private long cooldownSet;
    private long cooldown;
    private final boolean[] desTargetLost;
    private final Map<Boolean, List<EntityLivingBase>> spawnedEntitys;
    private EntityLivingBase target;
    public boolean exact;
    public boolean resetUpdate;

    public JobSpawner(EntityNPCInterface npc) {
        super(npc);
        this.dataEntitys[0] = new SpawnNPCData[0];
        this.dataEntitys[1] = new SpawnNPCData[0];
        this.offset = new int[2][];
        this.offset[0] = new int[]{0, 0, 0};
        this.offset[1] = new int[]{0, 0, 0};
        this.spawnType = new int[]{0, 0};
        this.number = new int[]{0, 0};
        this.cooldownSet = 3000L;
        this.desTargetLost = new boolean[]{true, true};
        this.spawnedEntitys = new HashMap<Boolean, List<EntityLivingBase>>();
        this.spawnedEntitys.put(false, new ArrayList());
        this.spawnedEntitys.put(true, new ArrayList());
        this.cooldown = System.currentTimeMillis() + this.cooldownSet;
        this.exact = false;
        this.resetUpdate = true;
        this.type = JobType.SPAWNER;
    }

    public SpawnNPCData add(SpawnNPCData sd, boolean isDead) {
        int type = isDead ? 1 : 0;
        SpawnNPCData[] newSData = new SpawnNPCData[this.dataEntitys[type].length + 1];
        System.arraycopy(this.dataEntitys[type], 0, newSData, 0, this.dataEntitys[type].length);
        newSData[this.dataEntitys[type].length] = sd;
        this.dataEntitys[type] = newSData;
        return sd;
    }

    @Override
    public void aiDeathExecute(Entity attackingEntity) {
        if (attackingEntity instanceof EntityLivingBase) {
            this.target = (EntityLivingBase)attackingEntity;
        }
        this.aiUpdateTask();
    }

    @Override
    public boolean aiShouldExecute() {
        boolean isDead;
        boolean bl = isDead = this.npc.func_110143_aJ() <= 0.0f;
        if (this.isEmpty(isDead) || this.npc.isKilled()) {
            return false;
        }
        this.target = this.getTarget();
        if (!this.spawnedEntitys.isEmpty()) {
            this.checkSpawns();
        }
        return this.target != null;
    }

    @Override
    public void aiStartExecuting() {
        this.number[0] = 0;
        this.number[1] = 0;
        for (int i = 0; i < 2; ++i) {
            for (EntityLivingBase entity : this.spawnedEntitys.get(i == 0)) {
                int slot = entity.getEntityData().func_74762_e("NpcSpawnerSlot");
                if (slot > this.number[i]) {
                    this.number[i] = slot;
                }
                this.setTarget(entity, this.getTarget());
            }
        }
    }

    @Override
    public void aiUpdateTask() {
        boolean isDead;
        boolean bl = isDead = this.npc.func_110143_aJ() <= 0.0f;
        if (!this.spawnedEntitys.get(isDead).isEmpty()) {
            if (this.npc.field_70170_p.func_82737_E() % 20L == 0L) {
                this.cooldown = System.currentTimeMillis() + (long)((double)this.cooldownSet * (this.npc.func_70681_au().nextFloat() < 0.5f ? 1.1 : 0.9));
            }
            this.checkSpawns();
            return;
        }
        if (this.getTarget() == null) {
            return;
        }
        if (!isDead && this.isOnCooldown()) {
            return;
        }
        int type = isDead ? 1 : 0;
        switch (this.spawnType[type]) {
            case 0: {
                this.spawnEntity(this.number[type], isDead);
                int n = type;
                this.number[n] = this.number[n] + 1;
                if (this.number[type] <= this.dataEntitys[type].length) break;
                this.number[type] = 0;
                break;
            }
            case 1: {
                HashMap<Integer, SpawnNPCData> map = new HashMap<Integer, SpawnNPCData>();
                for (int i = 0; i < this.dataEntitys[type].length; ++i) {
                    map.put(i, this.dataEntitys[type][i]);
                }
                while (map.size() > 7) {
                    map.remove(this.npc.func_70681_au().nextInt(map.size()));
                }
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    int slot;
                    this.number[type] = slot = ((Integer)iterator.next()).intValue();
                    this.spawnEntity(slot, isDead);
                }
                break;
            }
            default: {
                this.number[type] = this.npc.func_70681_au().nextInt(this.dataEntitys[type].length);
                this.spawnEntity(this.number[type], isDead);
            }
        }
    }

    public void checkSpawns() {
        for (int i = 0; i < 2; ++i) {
            ArrayList<EntityLivingBase> toDespawn = new ArrayList<EntityLivingBase>();
            for (EntityLivingBase spawn : this.spawnedEntitys.get(i == 0)) {
                if (this.shouldDelete(spawn)) {
                    spawn.field_70128_L = true;
                    toDespawn.add(spawn);
                    continue;
                }
                this.checkTarget(spawn);
            }
            for (EntityLivingBase entity : toDespawn) {
                this.spawnedEntitys.get(i == 0).remove(entity);
            }
        }
    }

    public void checkTarget(EntityLivingBase entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving liv = (EntityLiving)entity;
            if (liv.func_70638_az() == null || this.npc.func_70681_au().nextInt(100) == 1) {
                liv.func_70624_b(this.target);
            }
        } else if (entity.func_70643_av() == null || this.npc.func_70681_au().nextInt(100) == 1) {
            entity.func_70604_c(this.target);
        }
    }

    public void cleanCompound(NBTTagCompound compound) {
        for (int i = 0; i < 2; ++i) {
            String key = "DataEntitysWhen" + (i == 0 ? "Alive" : "Dead");
            for (int j = 0; j < compound.func_150295_c(key, 10).func_74745_c(); ++j) {
                Entity entity;
                NBTTagCompound sdNbt = compound.func_150295_c(key, 10).func_150305_b(j).func_74775_l("EntityNBT");
                String name = "type.empty";
                if ((sdNbt = sdNbt.func_74737_b()).func_150297_b("ClonedName", 8)) {
                    name = sdNbt.func_74779_i("ClonedName");
                } else if (sdNbt.func_150297_b("Name", 8)) {
                    name = sdNbt.func_74779_i("Name");
                } else if (sdNbt.func_150297_b("id", 8) && (entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(sdNbt.func_74779_i("id")), (World)Minecraft.func_71410_x().field_71441_e)) != null) {
                    name = entity.func_70005_c_();
                }
                compound.func_150295_c(key, 10).func_150305_b(j).func_82580_o("EntityNBT");
                compound.func_150295_c(key, 10).func_150305_b(j).func_74778_a("Name", name);
                if (sdNbt.func_150297_b("ClonedName", 8)) {
                    compound.func_150295_c(key, 10).func_150305_b(j).func_74778_a("ClonedName", sdNbt.func_74779_i("ClonedName"));
                }
                if (!sdNbt.func_150297_b("ClonedTab", 3)) continue;
                compound.func_150295_c(key, 10).func_150305_b(j).func_74768_a("ClonedTab", sdNbt.func_74762_e("ClonedTab"));
            }
        }
    }

    public void clear(boolean isDead) {
        this.dataEntitys[isDead ? 1 : 0] = new SpawnNPCData[0];
    }

    public SpawnNPCData get(int slot, boolean isDead) {
        if (slot < 0 || slot >= this.dataEntitys[isDead ? 1 : 0].length) {
            return null;
        }
        return this.dataEntitys[isDead ? 1 : 0][slot];
    }

    public long getCooldown() {
        return this.cooldownSet;
    }

    public boolean getDespawnOnTargetLost(boolean isDead) {
        return this.desTargetLost[isDead ? 1 : 0];
    }

    public String getId() {
        return this.id;
    }

    private List<EntityLivingBase> getNearbySpawned(boolean isDead) {
        ArrayList<EntityLivingBase> spawnList = new ArrayList<EntityLivingBase>();
        List list = new ArrayList();
        try {
            list = this.npc.field_70170_p.func_72872_a(EntityLivingBase.class, this.npc.func_174813_aQ().func_72314_b(60.0, 60.0, 60.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (EntityLivingBase entity : list) {
            if (entity.field_70128_L || !entity.getEntityData().func_74779_i("NpcSpawnerId").equals(this.id) || entity.getEntityData().func_74767_n("NpcSpawnerDead") != isDead) continue;
            spawnList.add(entity);
        }
        return spawnList;
    }

    public int[] getOffset(boolean isDead) {
        return this.offset[isDead ? 1 : 0];
    }

    public int getSpawnType(boolean isDead) {
        return this.spawnType[isDead ? 1 : 0];
    }

    private EntityLivingBase getTarget() {
        EntityLivingBase target = this.getTarget((EntityLivingBase)this.npc);
        if (target != null) {
            return target;
        }
        for (int i = 0; i < 2; ++i) {
            for (EntityLivingBase entity : this.spawnedEntitys.get(i == 0)) {
                target = this.getTarget(entity);
                if (target == null) continue;
                return target;
            }
        }
        return this.target;
    }

    private EntityLivingBase getTarget(EntityLivingBase entity) {
        if (entity == null || entity == this.npc && (entity.field_70128_L || (double)entity.func_110143_aJ() <= 0.0)) {
            return this.target;
        }
        if (entity instanceof EntityLiving) {
            this.target = ((EntityLiving)entity).func_70638_az();
            if (this.target != null && !this.target.field_70128_L && this.target.func_110143_aJ() > 0.0f) {
                return this.target;
            }
        }
        this.target = entity.func_70643_av();
        if (this.target != null && !this.target.field_70128_L && this.target.func_110143_aJ() > 0.0f) {
            if (entity.func_70032_d((Entity)this.target) > 40.0f) {
                return null;
            }
            return this.target;
        }
        return null;
    }

    private boolean isEmpty(boolean isDead) {
        for (SpawnNPCData sd : this.dataEntitys[isDead ? 1 : 0]) {
            if (sd.compound == null || !sd.compound.func_74764_b("id")) continue;
            return false;
        }
        return true;
    }

    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.cooldown;
    }

    @Override
    public void killed() {
        this.reset();
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = JobType.SPAWNER;
        this.id = compound.func_74779_i("SpawnerId");
        this.dataEntitys = new SpawnNPCData[2][];
        this.offset[0] = new int[]{0, 0, 0};
        this.offset[1] = new int[]{0, 0, 0};
        if (compound.func_150297_b("SpawnerDoesntDie", 1)) {
            Iterator iterator;
            int i;
            this.cooldownSet = 3000L;
            this.exact = false;
            this.resetUpdate = true;
            int[] osD = new int[]{compound.func_74762_e("SpawnerXOffset"), compound.func_74762_e("SpawnerYOffset"), compound.func_74762_e("SpawnerZOffset")};
            ArrayList<SpawnNPCData> sDs = new ArrayList<SpawnNPCData>();
            for (i = 1; i < 7; ++i) {
                if (!compound.func_150297_b("SpawnerNBT" + i, 10)) continue;
                SpawnNPCData sd = new SpawnNPCData();
                sd.compound = compound.func_74775_l("SpawnerNBT" + i);
                sDs.add(sd);
            }
            i = 0;
            if (compound.func_74767_n("SpawnerDoesntDie")) {
                this.spawnType[0] = 0;
                this.spawnType[1] = compound.func_74762_e("SpawnerType");
                this.offset[0] = new int[]{0, 0, 0};
                this.offset[1] = osD;
                this.desTargetLost[0] = true;
                this.desTargetLost[1] = compound.func_74767_n("DespawnOnTargetLost");
                this.dataEntitys[0] = new SpawnNPCData[0];
                this.dataEntitys[1] = new SpawnNPCData[sDs.size()];
                iterator = sDs.iterator();
                while (iterator.hasNext()) {
                    SpawnNPCData sd;
                    this.dataEntitys[1][i] = sd = (SpawnNPCData)iterator.next();
                    ++i;
                }
            } else {
                this.spawnType[0] = compound.func_74762_e("SpawnerType");
                this.spawnType[1] = 0;
                this.offset[0] = osD;
                this.offset[1] = new int[]{0, 0, 0};
                this.desTargetLost[0] = compound.func_74767_n("DespawnOnTargetLost");
                this.desTargetLost[1] = true;
                this.dataEntitys[0] = new SpawnNPCData[sDs.size()];
                this.dataEntitys[1] = new SpawnNPCData[0];
                iterator = sDs.iterator();
                while (iterator.hasNext()) {
                    SpawnNPCData sd;
                    this.dataEntitys[0][i] = sd = (SpawnNPCData)iterator.next();
                    ++i;
                }
            }
            return;
        }
        this.spawnType[0] = compound.func_74762_e("SpawnerWhenAlive");
        this.spawnType[1] = compound.func_74762_e("SpawnerWhenDead");
        this.cooldownSet = compound.func_74763_f("SpawnerCooldownSetting");
        this.offset[0] = compound.func_74759_k("OffsetWhenAlive");
        this.offset[1] = compound.func_74759_k("OffsetWhenDead");
        for (int j = 0; j < 2; ++j) {
            if (this.offset[j].length == 3) continue;
            int[] ns = new int[]{0, 0, 0};
            System.arraycopy(this.offset[j], 0, ns, 0, this.offset[j].length);
            this.offset[j] = ns;
        }
        this.desTargetLost[0] = compound.func_74767_n("DespawnOnTargetLostWhenAlive");
        this.desTargetLost[1] = compound.func_74767_n("DespawnOnTargetLostWhenDead");
        this.exact = compound.func_74767_n("IsExactOffsetSpawn");
        this.resetUpdate = compound.func_74767_n("DespawnInReset");
        for (int i = 0; i < 2; ++i) {
            NBTTagList nbt = compound.func_150295_c("DataEntitysWhen" + (i == 0 ? "Alive" : "Dead"), 10);
            this.dataEntitys[i] = new SpawnNPCData[nbt.func_74745_c()];
            for (int slot = 0; slot < nbt.func_74745_c(); ++slot) {
                this.dataEntitys[i][slot] = new SpawnNPCData(nbt.func_150305_b(slot));
            }
        }
    }

    public SpawnNPCData readJobCompound(int slot, boolean isDead, NBTTagCompound spawnNBT) {
        int type;
        int n = type = isDead ? 1 : 0;
        if (slot >= 0 && slot < this.dataEntitys[type].length) {
            SpawnNPCData sd = this.dataEntitys[type][slot];
            sd.readFromNBT(spawnNBT);
            return sd;
        }
        return this.add(new SpawnNPCData(spawnNBT), isDead);
    }

    @Override
    public void removeAllSpawned() {
        for (int i = 0; i < 2; ++i) {
            for (EntityLivingBase entity : this.spawnedEntitys.get(i == 0)) {
                entity.field_70128_L = true;
            }
            this.spawnedEntitys.get(i == 0).clear();
        }
    }

    public void removeCompound(NBTTagCompound compound) {
        for (int i = 0; i < 2; ++i) {
            String key = "DataEntitysWhen" + (i == 0 ? "Alive" : "Dead");
            for (int j = 0; j < compound.func_150295_c(key, 10).func_74745_c(); ++j) {
                compound.func_150295_c(key, 10).func_150305_b(j).func_82580_o("EntityNBT");
            }
        }
    }

    public void removeSpawned(int slot, boolean isDead) {
        int type;
        int n = type = isDead ? 1 : 0;
        if (slot < 0 || slot >= this.dataEntitys[type].length) {
            return;
        }
        SpawnNPCData[] newSData = new SpawnNPCData[this.dataEntitys[type].length - 1];
        int j = 0;
        for (int i = 0; i < this.dataEntitys[type].length; ++i) {
            if (i == slot) continue;
            newSData[j] = this.dataEntitys[type][i];
            ++j;
        }
        this.dataEntitys[type] = newSData;
    }

    @Override
    public void reset() {
        for (int i = 0; i < 2; ++i) {
            this.number[i] = 0;
            if (!this.spawnedEntitys.get(i == 0).isEmpty()) continue;
            this.spawnedEntitys.put(i == 0, this.getNearbySpawned(i == 0));
        }
        this.target = null;
        this.cooldown = 0L;
        this.checkSpawns();
    }

    @Override
    public void resetTask() {
        this.reset();
    }

    public void setCooldown(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks > 6000) {
            ticks = 6000;
        }
        this.cooldownSet = (long)ticks * 50L;
    }

    public void setCooldown(long ticks) {
        if (ticks < 0L) {
            ticks *= -1L;
        }
        if (ticks > 300000L) {
            ticks = 300000L;
        }
        this.cooldownSet = ticks;
    }

    public void setDespawnOnTargetLost(boolean isDead, boolean isLost) {
        this.desTargetLost[isDead ? 1 : 0] = isLost;
    }

    public void setSpawnType(boolean isDead, int readInt) {
        if (readInt < 0) {
            readInt *= -1;
        }
        if (readInt > 2) {
            readInt %= 3;
        }
        this.spawnType[isDead ? 1 : 0] = readInt;
    }

    private void setTarget(EntityLivingBase base, EntityLivingBase target) {
        if (base instanceof EntityLiving) {
            ((EntityLiving)base).func_70624_b(target);
        } else {
            base.func_70604_c(target);
        }
        if (this.npc == base) {
            this.target = target;
        }
    }

    public boolean shouldDelete(EntityLivingBase entity) {
        boolean isDead;
        SpawnNPCData sp = null;
        boolean sets = false;
        boolean bl = isDead = this.npc.func_110143_aJ() <= 0.0f;
        if (entity.getEntityData().func_150297_b("NpcSpawnerEntityId", 3) && entity.getEntityData().func_150297_b("NpcSpawnerSlot", 3) && entity.getEntityData().func_150297_b("NpcSpawnerId", 8) && entity.getEntityData().func_150297_b("NpcSpawnerDead", 1)) {
            if (this.resetUpdate && isDead != entity.getEntityData().func_74767_n("NpcSpawnerDead")) {
                return true;
            }
            sets = entity.getEntityData().func_74779_i("NpcSpawnerId").equals(this.id) && entity.getEntityData().func_74762_e("NpcSpawnerEntityId") == this.npc.func_145782_y();
            sp = this.get(entity.getEntityData().func_74762_e("NpcSpawnerSlot"), entity.getEntityData().func_74767_n("NpcSpawnerDead"));
        }
        if (!sets || sp == null) {
            return true;
        }
        if (entity.field_70128_L || entity.func_110143_aJ() <= 0.0f) {
            return true;
        }
        if (!this.npc.isInRange((Entity)entity, 40.0)) {
            entity.func_70604_c(null);
            entity.func_70107_b(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v);
            return false;
        }
        if (!this.desTargetLost[isDead ? 1 : 0]) {
            return false;
        }
        if (entity.func_94060_bK() == null) {
            this.setTarget(entity, this.getTarget());
        }
        if (entity.func_94060_bK() == null) {
            entity.func_70604_c(this.getTarget());
        }
        return entity.func_94060_bK() == null;
    }

    public int size(boolean isDead) {
        return this.dataEntitys[isDead ? 1 : 0].length;
    }

    @Override
    public IEntityLivingBase<?> spawnEntity(int slot, boolean isDead) {
        SpawnNPCData spawn = this.get(slot, isDead);
        if (spawn == null) {
            return null;
        }
        EntityLivingBase base = this.spawnEntity(spawn, isDead, null);
        if (base == null) {
            return null;
        }
        return (IEntityLivingBase)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)base);
    }

    public EntityLivingBase spawnEntity(SpawnNPCData sd, boolean isDead, EntityLivingBase base) {
        if (this.getTarget() == null || sd.compound == null || !sd.compound.func_74764_b("id")) {
            return null;
        }
        if (!isDead && this.npc.func_70032_d((Entity)this.getTarget()) > (float)this.npc.stats.aggroRange) {
            return null;
        }
        int type = isDead ? 1 : 0;
        Object trueEntity = base != null ? base : this.npc;
        int add = !this.exact && this.spawnType[type] == 1 ? 2 : 0;
        double x = trueEntity.field_70165_t + (double)((float)(add + this.offset[type][0]) * (this.exact ? 1.0f : trueEntity.func_70681_au().nextFloat() * (float)(trueEntity.func_70681_au().nextFloat() < 0.5f ? -1 : 1))) - 0.5 + (double)trueEntity.func_70681_au().nextFloat();
        double y = trueEntity.field_70163_u + (double)((float)(add + this.offset[type][1]) * (this.exact ? 1.0f : trueEntity.func_70681_au().nextFloat() * (float)(trueEntity.func_70681_au().nextFloat() < 0.5f ? -1 : 1)));
        double z = trueEntity.field_70161_v + (double)((float)(add + this.offset[type][2]) * (this.exact ? 1.0f : trueEntity.func_70681_au().nextFloat() * (float)(trueEntity.func_70681_au().nextFloat() < 0.5f ? -1 : 1))) - 0.5 + (double)trueEntity.func_70681_au().nextFloat();
        this.npc.func_70661_as().func_75492_a(x, y, z, 1.0);
        Path path = this.npc.func_70661_as().func_75505_d();
        this.npc.func_70661_as().func_75492_a(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, 1.0);
        if (path != null && path.func_75870_c() != null) {
            x = path.func_75870_c().field_75839_a;
            y = path.func_75870_c().field_75837_b;
            z = path.func_75870_c().field_75838_c;
        }
        NBTTagCompound compound = sd.compound;
        if (sd.typeClones == 2) {
            int tab;
            String name = sd.compound.func_74779_i("ClonedName");
            compound = ServerCloneController.Instance.getCloneData(null, name, tab = sd.compound.func_74762_e("ClonedTab"));
            if (compound == null) {
                compound = sd.compound;
            } else {
                sd.compound = compound;
                sd.compound.func_74779_i("ClonedName");
                sd.compound.func_74762_e("ClonedTab");
            }
        }
        ServerCloneController.Instance.cleanTags(compound);
        compound.func_74782_a("Pos", (NBTBase)NBTTags.nbtDoubleList(x, y, z));
        Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)trueEntity.field_70170_p);
        if (entity == null || trueEntity.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && entity instanceof EntityMob) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(new BlockPos((Entity)npc));
        }
        trueEntity.field_70170_p.func_72838_d(entity);
        EntityLivingBase living = (EntityLivingBase)entity;
        living.getEntityData().func_74768_a("NpcSpawnerEntityId", this.npc.func_145782_y());
        living.getEntityData().func_74778_a("NpcSpawnerId", this.id);
        living.getEntityData().func_74768_a("NpcSpawnerSlot", this.number[type]);
        living.getEntityData().func_74757_a("NpcSpawnerDead", isDead);
        this.setTarget(living, this.npc.func_70638_az() != null ? this.npc.func_70638_az() : this.target);
        living.func_70107_b(x, y, z);
        if (living instanceof EntityNPCInterface) {
            EntityNPCInterface sSnpc = (EntityNPCInterface)living;
            sSnpc.advanced.spawner = this.npc;
            sSnpc.stats.spawnCycle = 4;
            sSnpc.stats.respawnTime = 0;
            sSnpc.ais.returnToStart = false;
            sSnpc.ais.onAttack = 0;
        }
        this.spawnedEntitys.get(isDead).add(living);
        return living;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.load(compound);
        compound.func_74778_a("SpawnerId", this.id);
        compound.func_74768_a("SpawnerWhenAlive", this.spawnType[0]);
        compound.func_74768_a("SpawnerWhenDead", this.spawnType[1]);
        compound.func_74772_a("SpawnerCooldownSetting", this.cooldownSet);
        compound.func_74783_a("OffsetWhenAlive", this.offset[0]);
        compound.func_74783_a("OffsetWhenDead", this.offset[1]);
        compound.func_74757_a("DespawnOnTargetLostWhenAlive", this.desTargetLost[0]);
        compound.func_74757_a("DespawnOnTargetLostWhenDead", this.desTargetLost[1]);
        compound.func_74757_a("IsExactOffsetSpawn", this.exact);
        compound.func_74757_a("DespawnInReset", this.resetUpdate);
        for (int i = 0; i < 2; ++i) {
            NBTTagList list = new NBTTagList();
            for (SpawnNPCData sd : this.dataEntitys[i]) {
                list.func_74742_a((NBTBase)sd.writeToNBT());
            }
            compound.func_74782_a("DataEntitysWhen" + (i == 0 ? "Alive" : "Dead"), (NBTBase)list);
        }
        return compound;
    }
}

